---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.4
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 16, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Corrected sp_SEL_USER_SPORTS, changed LANGUAGE_ID to SPORTS_ID 
-- MSW 092700 Corrected sp_SEL_UserID_By_Screenname, added % for like condition
-- MSW 092700 Deleted PROCEDURE sp_UPD_USER_DEMOGRAPHICS
-- MSW 092700 Changed PROCEDURE sp_INS_USER_DETAIL to incorporate demographics deleted in procedue sp_UPD_USER_DEMOGRAPHICS
-- MSW 092700 Changed PROCEDURE sp_UPD_USER_DETAIL to incorporate demographics deleted in procedue sp_UPD_USER_DEMOGRAPHICS
-- MSW 092700 Deleted PROCEDURE sp_SEL_USER_DEMOGRAPHICS
-- MSW 092700 Changed PROCEDURE sp_SEL_USER_DETAIL to incorporate demographics deleted in procedue sp_SEL_USER_DEMOGRAPHICS
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 100300 Removed ERROR_CODEs(6519, 6520) from pkg_ALKINDI_USER.sp_INS_USER_INTEREST
-- MSW 100300 Removed ERROR_CODEs(6521, 6522) from pkg_ALKINDI_USER.sp_INS_USER_ACTIVITY
-- MSW 100300 Removed ERROR_CODEs(6523, 6524) from pkg_ALKINDI_USER.sp_INS_USER_PROFESSION
-- MSW 100300 Removed ERROR_CODEs(6525, 6526) from pkg_ALKINDI_USER.sp_INS_USER_MOVIE_GENRE
-- MSW 100300 Removed ERROR_CODEs(6527, 6528) from pkg_ALKINDI_USER.sp_INS_USER_SPORTS
-- MSW 100300 Removed ERROR_CODEs(6529, 6530) from pkg_ALKINDI_USER.sp_INS_USER_LANGUAGE
-- MSW 100300 Removed ERROR_CODE(6552) from pkg_ALKINDI_USER.sp_INSERT_Evals
-- MSW 100300 Changed pkg_ALKINDI_USER.sp_INSERT_Evals to insert into the ERRORS table when an exception occurs
-- MSW 100500 Corrected pkg_ALKINDI_USER.sp_VERIFY_LOGIN_PASSWORD, SQL Statement was selecting values into wrong variables
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 100900 Changed pkg_ALKINDI_USER.sp_SELECT_QUESTION_ID to take a LOGIN as an input instead of a user_id
-- AHW 101000 Added columns USER_STATUS_ID, ADVISOR_STATUS_ID to result set for sp_SEL_USER_DETAIL
-- MSW 101100 Changed pkg_ALKINDI_USER.sp_VERIFY_LOGIN_PASSWORD to be case insensitive for email and password
-- MSW 101100 Changed pkg_ALKINDI_USER.sp_VERIFY_UNIQUE_SCREENNAME to be case insensitive for screenname check
-- AHW 101300 Added comments to stored procedures
-- MSW 102000 Changed pkg_ALKINDI_USER.sp_INS_USER_DETAIL to accept i_EDUCATION_ID as an input
-- MSW 102000 Changed pkg_ALKINDI_USER.sp_UPD_USER_DETAIL to accept i_EDUCATION_ID as an input
-- MSW 102000 Changed pkg_ALKINDI_USER.sp_SEL_USER_DETAIL to return EDUCATION_ID


---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_USER
AS
  TYPE USER_cursor_type is REF CURSOR;

  PROCEDURE sp_CREATE_USER_ID(
	io_USER_ID 			IN OUT 	USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_VERIFY_LOGIN_PASSWORD(
 	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
 	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
      o_USER_ID 			OUT 		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_VERIFY_UNIQUE_SCREENNAME(						-- MSW 09252000
 	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SELECT_QUESTION_ID(
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	o_QUESTION1			OUT		USER_DETAIL.QUESTION1%TYPE,
	o_QUESTION2			OUT		USER_DETAIL.QUESTION2%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_VERIFY_QUESTION_ANSWER(
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	o_USER_ID			OUT		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SELECT_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_PASSWORD			OUT		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_UPDATE_USER_STATUS_ID(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_STATUS_ID		IN		USER_DETAIL.USER_STATUS_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_UPDATE_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_PASSWORD_OLD	IN		USER_DETAIL.PASSWORD%TYPE,
	i_USER_PASSWORD_NEW	IN		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_FRIEND_EMAIL(
	i_USER_ID			IN		USER_FRIEND_EMAIL.USER_ID%TYPE,
	i_FRIEND_EMAIL		IN		USER_FRIEND_EMAIL.FRIEND_EMAIL%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_USER_MY_LIST(
	i_USER_ID			IN		USER_MY_LIST.USER_ID%TYPE,
	i_PRODUCT_ID		IN		USER_MY_LIST.PRODUCT_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_INS_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_EDUCATION_ID		IN		USER_DETAIL.EDUCATION_ID%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER);
		
  PROCEDURE sp_INS_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_INTEREST_ID		IN		REL_USER_INTEREST.INTEREST_ID%TYPE);

  PROCEDURE sp_INS_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_ACTIVITY_ID		IN		REL_USER_ACTIVITY.ACTIVITY_ID%TYPE);

  PROCEDURE sp_INS_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_PROFESSION_ID		IN		REL_USER_PROFESSION.PROFESSION_ID%TYPE);

  PROCEDURE sp_INS_USER_MOVIE_GENRE(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	i_MOVIE_GENRE_ID		IN		REL_USER_MOVIE_GENRE.MOVIE_GENRE_ID%TYPE);

  PROCEDURE sp_INS_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_SPORTS_ID			IN		REL_USER_SPORTS.SPORTS_ID%TYPE);

  PROCEDURE sp_INS_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_LANGUAGE_ID		IN		REL_USER_LANGUAGE.LANGUAGE_ID%TYPE);

  PROCEDURE sp_UPD_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_EDUCATION_ID		IN		USER_DETAIL.EDUCATION_ID%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_DEL_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

END pkg_ALKINDI_USER;
/

SHOW ERRORS


-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_USER
AS
 PROCEDURE sp_CREATE_USER_ID (
	io_USER_ID			IN OUT	USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	SELECT sq_USER_ID.NEXTVAL INTO io_USER_ID FROM DUAL;

	INSERT INTO USER_ID (USER_ID, DATE_CREATED)
	VALUES(io_USER_ID, sysdate);

	IF SQL%NOTFOUND THEN 
		io_USER_ID	 :=  0;
		o_ERROR_CODE := 6500;
	ELSE
		o_ERROR_CODE :=  0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6501;						    -- general error when creating user id
	io_USER_ID		:= 0;
 END sp_CREATE_USER_ID;

-- ==========================================================================================

 PROCEDURE sp_VERIFY_LOGIN_PASSWORD(
 	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
 	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
      o_USER_ID 			OUT 		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS
	v_USER_STATUS_ID NUMBER;
   BEGIN
      SELECT USER_ID,USER_STATUS_ID INTO o_USER_ID, v_USER_STATUS_ID
        FROM USER_DETAIL
	 WHERE UPPER(EMAIL) = UPPER(i_EMAIL)
	   AND UPPER(PASSWORD) = UPPER(i_PASSWORD);

	IF v_USER_STATUS_ID = 4 THEN 
		o_ERROR_CODE:= 6502;							-- when email and password cannot be verified
	ELSE
		o_ERROR_CODE:= 0;
	END IF; 

   EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6503;						-- no data is found
		o_USER_ID		:= 0;
 END sp_VERIFY_LOGIN_PASSWORD;

-- ==========================================================================================

  PROCEDURE sp_VERIFY_UNIQUE_SCREENNAME(						-- MSW 09252000
 	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
  IS 
	v_SCREENNAME_COUNT NUMBER;
  BEGIN

	SELECT COUNT(SCREENNAME) INTO v_SCREENNAME_COUNT
	  FROM USER_DETAIL
	 WHERE UPPER(SCREENNAME) = UPPER(i_SCREENNAME);

	IF v_SCREENNAME_COUNT > 0 THEN 
		o_ERROR_CODE:= 6504;							-- cannot verify unique screenname		
	ELSE
		o_ERROR_CODE:= 0;
	END IF; 

  EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6505;						-- other errors when verifying unique screenname
  END sp_VERIFY_UNIQUE_SCREENNAME;

-- ==========================================================================================

 PROCEDURE sp_SELECT_QUESTION_ID(
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	o_QUESTION1			OUT		USER_DETAIL.QUESTION1%TYPE,
	o_QUESTION2			OUT		USER_DETAIL.QUESTION2%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
  IS BEGIN
	o_ERROR_CODE:= 0;

	SELECT QUESTION1, QUESTION2 INTO o_QUESTION1, o_QUESTION2
	  FROM USER_DETAIL
	 WHERE EMAIL = i_EMAIL;

  EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6506;						 -- no dat is found for the supplied email address
  END sp_SELECT_QUESTION_ID;

-- ==========================================================================================

  PROCEDURE sp_VERIFY_QUESTION_ANSWER(
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	o_USER_ID			OUT		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE:= 0;

	SELECT USER_ID INTO o_USER_ID
	  FROM USER_DETAIL
	 WHERE EMAIL = i_EMAIL
	   AND QUESTION1 = i_QUESTION1
	   AND ANSWER1 = i_ANSWER1
	   AND QUESTION2 = i_QUESTION2
	   AND ANSWER2 = i_ANSWER2;

  EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6507;						   -- no data is found for the supplied email address, 
												   -- questions and answers
  END sp_VERIFY_QUESTION_ANSWER;

-- ==========================================================================================

  PROCEDURE sp_SELECT_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_PASSWORD			OUT		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE:= 0;

	SELECT PASSWORD INTO o_PASSWORD
	  FROM USER_DETAIL
	 WHERE USER_ID = i_USER_ID;

  EXCEPTION
	WHEN NO_DATA_FOUND THEN
		o_ERROR_CODE	:= 6508;						-- no data is found for the supplied user_id
  END sp_SELECT_PASSWORD;

-- ==========================================================================================

  PROCEDURE sp_UPDATE_USER_STATUS_ID(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_STATUS_ID		IN		USER_DETAIL.USER_STATUS_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	UPDATE USER_DETAIL
	   SET USER_STATUS_ID = i_USER_STATUS_ID
	 WHERE USER_ID = i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6509;							 -- unable to update user_id and user_status_id
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6510;
  END sp_UPDATE_USER_STATUS_ID;

-- ==========================================================================================

  PROCEDURE sp_UPDATE_PASSWORD(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_USER_PASSWORD_OLD	IN		USER_DETAIL.PASSWORD%TYPE,
	i_USER_PASSWORD_NEW	IN		USER_DETAIL.PASSWORD%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	UPDATE USER_DETAIL
	   SET PASSWORD = i_USER_PASSWORD_NEW
	 WHERE USER_ID = i_USER_ID
	   AND PASSWORD = i_USER_PASSWORD_OLD;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6511;							 -- unable to update password
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6512;							  -- other errors when updating password
  END sp_UPDATE_PASSWORD;

-- ==========================================================================================

  PROCEDURE sp_INS_FRIEND_EMAIL(
	i_USER_ID			IN		USER_FRIEND_EMAIL.USER_ID%TYPE,
	i_FRIEND_EMAIL		IN		USER_FRIEND_EMAIL.FRIEND_EMAIL%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN

	INSERT INTO USER_FRIEND_EMAIL
	VALUES (i_USER_ID, i_FRIEND_EMAIL, sysdate);

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6513;							   -- unable to insert friend email
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6514;							   -- other errors when inserting friend email
  END sp_INS_FRIEND_EMAIL;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_MY_LIST(
	i_USER_ID			IN		USER_MY_LIST.USER_ID%TYPE,
	i_PRODUCT_ID		IN		USER_MY_LIST.PRODUCT_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN

	INSERT INTO USER_MY_LIST
	VALUES (i_USER_ID, i_PRODUCT_ID, sysdate);

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6515;							    -- unable to insert user_id and product_id
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6516;							    -- other errors when inserting user_id and product_id
  END sp_INS_USER_MY_LIST;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_EDUCATION_ID		IN		USER_DETAIL.EDUCATION_ID%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN

	INSERT INTO USER_DETAIL (USER_ID, EMAIL, SCREENNAME, PASSWORD, QUESTION1, ANSWER1, QUESTION2, ANSWER2, HOME_ZIP_CODE, SEX_ID, BIRTHDATE, EDUCATION_ID, WEEKLY_ENT_EXP)
	VALUES (i_USER_ID, i_EMAIL, i_SCREENNAME, i_PASSWORD, i_QUESTION1, i_ANSWER1, i_QUESTION2, i_ANSWER2, i_HOME_ZIP_CODE, i_SEX_ID, i_BIRTHDATE, i_EDUCATION_ID, i_WEEKLY_ENT_EXP);

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6517;							     -- unable to insert user detail
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6518;							     -- other errors when inserting user detail
  END sp_INS_USER_DETAIL;

-- ==========================================================================================
		
  PROCEDURE sp_INS_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_INTEREST_ID		IN		REL_USER_INTEREST.INTEREST_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_INTEREST
	VALUES (i_USER_ID, i_INTEREST_ID);

  END sp_INS_USER_INTEREST;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_ACTIVITY_ID		IN		REL_USER_ACTIVITY.ACTIVITY_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_ACTIVITY
	VALUES (i_USER_ID, i_ACTIVITY_ID);

  END sp_INS_USER_ACTIVITY;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_PROFESSION_ID		IN		REL_USER_PROFESSION.PROFESSION_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_PROFESSION
	VALUES (i_USER_ID, i_PROFESSION_ID);

  END sp_INS_USER_PROFESSION;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_MOVIE_GENRE(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	i_MOVIE_GENRE_ID		IN		REL_USER_MOVIE_GENRE.MOVIE_GENRE_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_MOVIE_GENRE
	VALUES (i_USER_ID, i_MOVIE_GENRE_ID);

  END sp_INS_USER_MOVIE_GENRE;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_SPORTS_ID			IN		REL_USER_SPORTS.SPORTS_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_SPORTS
	VALUES (i_USER_ID, i_SPORTS_ID);

  END sp_INS_USER_SPORTS;

-- ==========================================================================================

  PROCEDURE sp_INS_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_LANGUAGE_ID		IN		REL_USER_LANGUAGE.LANGUAGE_ID%TYPE)

   IS BEGIN

	INSERT INTO REL_USER_LANGUAGE
	VALUES (i_USER_ID, i_LANGUAGE_ID);

  END sp_INS_USER_LANGUAGE;

-- ==========================================================================================

  PROCEDURE sp_UPD_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	i_EMAIL			IN		USER_DETAIL.EMAIL%TYPE,
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	i_PASSWORD			IN		USER_DETAIL.PASSWORD%TYPE,
	i_QUESTION1			IN		USER_DETAIL.QUESTION1%TYPE,
	i_ANSWER1			IN		USER_DETAIL.ANSWER1%TYPE,
	i_QUESTION2			IN		USER_DETAIL.QUESTION2%TYPE,
	i_ANSWER2			IN		USER_DETAIL.ANSWER2%TYPE,
	i_HOME_ZIP_CODE		IN		USER_DETAIL.HOME_ZIP_CODE%TYPE,
	i_SEX_ID			IN		USER_DETAIL.SEX_ID%TYPE,
	i_BIRTHDATE			IN		USER_DETAIL.BIRTHDATE%TYPE,
	i_EDUCATION_ID		IN		USER_DETAIL.EDUCATION_ID%TYPE,
	i_WEEKLY_ENT_EXP		IN		USER_DETAIL.WEEKLY_ENT_EXP%TYPE,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN

	UPDATE USER_DETAIL
	   SET USER_ID=i_USER_ID
	     , EMAIL=i_EMAIL
	     , SCREENNAME=i_SCREENNAME
	     , PASSWORD=i_PASSWORD
	     , QUESTION1=i_QUESTION1
	     , ANSWER1=i_ANSWER1
	     , QUESTION2=i_QUESTION2
	     , ANSWER2=i_ANSWER2
	     , HOME_ZIP_CODE=i_HOME_ZIP_CODE
	     , SEX_ID=i_SEX_ID
	     , BIRTHDATE=i_BIRTHDATE
	     , EDUCATION_ID = i_EDUCATION_ID
	     , WEEKLY_ENT_EXP=i_WEEKLY_ENT_EXP
	 WHERE USER_ID = i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6531;								-- unable to update user detail
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6532;								-- other errors when updating user detail
  END sp_UPD_USER_DETAIL;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_INTEREST
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6533;								-- unable to delete user from REL_USER_INTEREST
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6534;								-- other errors when deleting user from REL_USER_INTEREST
   END sp_DEL_USER_INTEREST;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_ACTIVITY
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6535;								-- unable to delete user from REL_USER_ACTIVITY
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6536;								-- other errors when deleting user from REL_USER_ACTIVITY
  END sp_DEL_USER_ACTIVITY;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_PROFESSION
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6537;							       -- unable to delete user from REL_USER_PROFESSION
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6538;								 -- other errors when deleting from REL_USER_PROFESSION
  END sp_DEL_USER_PROFESSION;

-- ==========================================================================================

  PROCEDURE sp_DEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_MOVIE_GENRE
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6539;								 -- unable to delete user from REL_USER_MOVIE_GENRE
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6540;								 -- other errors when deleting user from REL_USER_MOVIE_GENRE
  END sp_DEL_MovieGenre;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_SPORTS
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6541;								 -- unable to delete user from REL_USER_SPORTS
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6542;								 -- other errors when deleting user from REL_USER_SPORTS
  END sp_DEL_USER_SPORTS;

-- ==========================================================================================

  PROCEDURE sp_DEL_USER_LANGUAGE(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	DELETE FROM REL_USER_LANGUAGE
	 WHERE USER_ID=i_USER_ID;

	IF SQL%NOTFOUND THEN 
		o_ERROR_CODE:= 6543;								-- unable to delete user from REL_USER_LANGUAGE
	ELSE
		o_ERROR_CODE:= 0;
	END IF;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6544;								-- other errors when deleting user by user_id
   END sp_DEL_USER_LANGUAGE;

-- ==========================================================================================

   PROCEDURE sp_SEL_USER_DETAIL(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	 SELECT USER_ID, EMAIL, SCREENNAME, PASSWORD, QUESTION1, ANSWER1
	      , QUESTION2, ANSWER2, HOME_ZIP_CODE, SEX_ID, BIRTHDATE, EDUCATION_ID
		, WEEKLY_ENT_EXP, USER_STATUS_ID, ADVISOR_STATUS_ID
	   FROM USER_DETAIL
	  WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6545;								 -- general errors when selecting user detail by user_id
   END sp_SEL_USER_DETAIL;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_INTEREST(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	SELECT INTEREST_ID
	  FROM REL_USER_INTEREST
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6546;								 -- general errors when selecting user interest by user_id
  END sp_SEL_USER_INTEREST;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_ACTIVITY(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	SELECT ACTIVITY_ID
	  FROM REL_USER_ACTIVITY
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6547;								-- general errors when selecting user activity by user_id									
   END sp_SEL_USER_ACTIVITY;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_PROFESSION(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR
	SELECT PROFESSION_ID
	  FROM REL_USER_PROFESSION
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6548;								-- general errors when selecting user profession by user_id	
   END sp_SEL_USER_PROFESSION;

-- ==========================================================================================

  PROCEDURE sp_SEL_MovieGenre(
	i_USER_ID			IN		REL_USER_MOVIE_GENRE.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR

	SELECT MOVIE_GENRE_ID
	  FROM REL_USER_MOVIE_GENRE
	 WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6549;							-- general errors when selecting movie genre
		CLOSE o_USER_cursor_type;
 END sp_SEL_MovieGenre;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_SPORTS(
	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR

	SELECT SPORTS_ID
	  FROM REL_USER_SPORTS
	 WHERE USER_ID = i_USER_ID;


   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6550;								-- general errors when selecting user sports
   END sp_SEL_USER_SPORTS;

-- ==========================================================================================

  PROCEDURE sp_SEL_USER_LANGUAGE(

	i_USER_ID			IN		USER_DETAIL.USER_ID%TYPE,
	o_USER_cursor_type	OUT		USER_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;

	OPEN o_USER_cursor_type FOR

	SELECT LANGUAGE_ID
	  FROM REL_USER_LANGUAGE
	 WHERE USER_ID = i_USER_ID;


   EXCEPTION
	WHEN OTHERS THEN
	o_ERROR_CODE	:= 6551;								-- general errors when selecting user language
   END sp_SEL_USER_LANGUAGE;

-- ==========================================================================================

END pkg_ALKINDI_USER;
/

SHOW ERRORS
